/*
 
 ADOBE CONFIDENTIAL
 ___________________
 
 Copyright 2012 Adobe Systems Incorporated
 All Rights Reserved.
 
 NOTICE:  All information contained herein is, and remains
 the property of Adobe Systems Incorporated and its suppliers,
 if any.  The intellectual and technical concepts contained
 herein are proprietary to Adobe Systems Incorporated and its
 suppliers and are protected by trade secret or copyright law.
 Dissemination of this information or reproduction of this material
 is strictly forbidden unless prior written permission is obtained
 from Adobe Systems Incorporated.
 
 */

//---------------   GLOBAL VARIABLES   ---------------
var helpDoc = MM.HELP_objFluidElement;
var LIST_CLASSES;
var LIST_IDS;
var allClasses;
var allUnusedIDs;
var classesPopulated = false;
var idsPopulated = false;

elementCSSType ={
	NONE : 0,
	ID : 1,
	CLASS : 2
}

//---------------     API FUNCTIONS    ---------------

function isDOMRequired()
{
	//alert('isDomRequired()');
	return false;
}

function commandButtons()
{
//	alert('commandButtons');
   return new Array( MM.BTN_OK,     "doInsertDiv()",
                     MM.BTN_Cancel, "window.close()",
                     MM.BTN_Help,   "displayHelp()");
}

//---------------    LOCAL FUNCTIONS   ---------------

function setFocusforIDField()
{
	if (document.theForm.fgElement.checked)
	{
		document.forms[0].fgEleClass.disabled = true;
		document.forms[0].fgEleID.disabled = false;
		// There is timing issue(#3436218) in OSX 10.8, due to which focus is not applied 
		// since enabling the textbox is taking sometime. fixing this using a timer
		window.setTimeout(setFocusToText, 100);
	}		
}
function setFocusForClassField()
{
	if (document.theForm.fgElement.checked)
	{
		document.forms[0].fgEleClass.disabled = false;
		document.forms[0].fgEleID.disabled = true;
		document.forms[0].fgEleClass.focus();
	}
}
function setFocusToText()
{
	document.forms[0].fgEleID.focus();	
}
function FindOneOf(str, set)
{
	var strlen = str.length;
	var setlen = set.length;
	var i = 0;
	var j = 0;
	for(i=0; i< setlen; i++)
	{
		for(j = 0; j<strlen; j++)
		{
			if(str.charAt(j) == set.charAt(i))
			{
				return true;
			}
		}
	}
	return false;
}

function showError(msg)
{
	var eleTable = document.getElementById("errorTable");
	if (eleTable)
		eleTable.style.display = "block";
	var ele = document.getElementById("errMsg");
	if (ele)
		ele.innerHTML = msg;
}

function hideError()
{
	var eleTable = document.getElementById("errorTable");
	if (eleTable)
		eleTable.style.display = "none";
	var ele = document.getElementById("errMsg");
	if (ele)
		ele.innerHTML = "";
}

function validateString(str)
{
	var notAllowedSet = ".,?/\\'\"|][}{=+)(*&^%$#@!~`"; // this list i got from renameClass.cpp

	if(FindOneOf(str[0], "0123456789"))
	{
		var msg = dw.loadString("fgClassIdName/error/startingWithNumber");//"space not allowed"
		showError(msg);
		return false;
	}
	else if(str[0] == '-' && (str.length == 1 || FindOneOf(str[1], "0123456789-"))) //if starting with '-', check second char
	{
		var msg = dw.loadString("fgClassIdName/error/specialCharsNotAllowed");//"special chars not allowed"
		showError(msg);
		return false;
	}
	else if(str.search(" ") > -1)
	{
		var msg = dw.loadString("fgClassIdName/error/spacesNotAllowed");//"space not allowed"
		showError(msg);
		return false;
	}	
	else if(FindOneOf(str, notAllowedSet ))	
	{
		var msg = dw.loadString("fgClassIdName/error/specialCharsNotAllowed");//"special chars not allowed"
		showError(msg);
		return false;
	}
	return true;
}

function trimDefaultSelectorList(selectorList)
{
	// This list has to be updated whenever more standard Fluidgrid classes are added 
    var preDefClasses = new Array(".fluid", ".fluidList", ".gridContainer", ".hide_mobile", ".hide_tablet", ".hide_desktop", ".ie6", ".zeroMargin_mobile", ".zeroMargin_tablet", ".zeroMargin_desktop");
    var idx;
	for(idx = 0; idx < preDefClasses.length; idx++) 
    {
        var index = selectorList.indexOf(preDefClasses[idx]);
        if (index >= 0)
        {
            selectorList.splice(index, 1);            
        }
    }   
}

function populateClassList()
{
	//alert('populateClassList');	
	if (classesPopulated)
		return;

	var dom = dw.getDocumentDOM();
	if (dom)
	{
	    allClasses = dom.getSelectorsDefinedInFluidGridStylesheet('class');
	    trimDefaultSelectorList(allClasses);
		for (i = 0; i < allClasses.length; i++)
		{
			if (allClasses[i][0] == '.')
				allClasses[i] = allClasses[i].slice(1);
		}
		LIST_CLASSES.setAll(allClasses);
	}

	classesPopulated = true;
}

function populateIDList()
{
	//alert('populateIDList');	
	if (idsPopulated)
		return;

	var dom = dw.getDocumentDOM();
	if (dom)
	{
		var ids = dom.getSelectorsDefinedInStylesheet('id');
		allUnusedIDs = new Array();
		for (i = 0; i < ids.length; i++)
		{
			if (ids[i][0] == '#')
				ids[i] = ids[i].slice(1);
			if (!isIDInUse(ids[i]))
				allUnusedIDs.push(ids[i]);
		}
		LIST_IDS.setAll(allUnusedIDs);
	}
	idsPopulated = true;
}

function initializeFGUI()
{
	//alert('initializeUI');	
	var i;
	var dom = dw.getDocumentDOM();

	LIST_CLASSES = new ListControl('fgEleClass');
	LIST_IDS = new ListControl('fgEleID');

	LIST_CLASSES.setIndex(-1);
	LIST_IDS.setIndex(-1);		// we need this to verify for duplicate before updating the CSS

	populateClassList();
	
	if (dw.getPreferenceString("CSS Layout Framework Preferences", "Insert Fluid Element", "TRUE") == 'TRUE')
	{
		document.theForm.fgElement.checked = true;
	} else {
		document.theForm.fgElement.checked = false;
	}
	toggleFGInputs();
}

function toggleFGInputs()
{
	if (document.theForm.fgElement.checked)	{
		if (document.getElementById('selectClass').checked)
			setFocusForClassField();
		else
			setFocusforIDField();
	}
	else {
		document.theForm.fgEleClass.disabled = true;
		document.theForm.fgEleID.disabled = true;
		hideError();
	}
}

function isIDInUse(idStr)
{
	//alert('isIDInUser');	
	var dom = dw.getDocumentDOM();
	if (dom)
	{	
		var nodeList = dom.getElementsByAttributeName('id');
		if (nodeList)
		{
			for (var i = 0; i < nodeList.length; i++)
			{
			  var nodeId = nodeList[i].getAttribute('id');
				if (nodeId && (nodeId.toLowerCase() == idStr.toLowerCase()))
					return true;
			}
		}
	}
	return false;
}
	
function doInsertDiv()
{
	//alert('doInsertDiv');
	var tagName = document.getElementById("tagname").value;
	var dom = dw.getDocumentDOM();
	
	if (!document.theForm.fgElement.checked)
	{
		tagName = tagName.toLowerCase();
		var content = '';
		if (tagName == 'figure') {
			var figureContent = dw.loadString('Objects/layout/figure/defaultNonFluidContent');
			content = dw.loadString('Objects/layout/figcaption/defaultContent');
			content = figureContent + '<figcaption>' + content + '</figcaption>';
		}
		else {
			content = dw.loadString('Objects/layout/' + tagName + '/defaultNonFluidContent');
		}
		var html = '<' + tagName + '>' + content + '</' + tagName + '>';

	    if (dw.getFocus(false) == 'textView') {
			var domSource = dom.source;
            var selOffsets = dom.source.getSelection();
			domSource.insert(selOffsets[1], html); // insert at the end of the selection in code view
            domSource.setSelection(selOffsets[1], selOffsets[1] + html.length); // Select the inserted code
            domSource.syncCodeToDOM();
        }
        else {
            dom.insertHTML(html, false, false); // this will select the newly inserted snippet
        }
		
		dw.setPreferenceString("CSS Layout Framework Preferences", "Insert Fluid Element", "FALSE");
		dom.setInactiveDeviceIconsModified();
		
		window.close();
		return;
	}
		
	if (dw.getPreferenceString("CSS Layout Framework Preferences", "Insert Fluid Element", "TRUE") != 'TRUE') {
		dw.setPreferenceString("CSS Layout Framework Preferences", "Insert Fluid Element", "TRUE");
	}

	var cssType;
	var cssSelectorName;
	
	if (dom)
	{
		if(document.getElementById('selectID').checked)
		{
			cssSelectorName =document.forms[0].fgEleID.value;
			cssType = elementCSSType.ID;
			dw.logEvent(UT_FLUID_GRID, UT_FLUID_GRID_ELEMENT_INSERTED_WITH_ID);
		}		
		else if(document.getElementById('selectClass').checked)
		{
			cssSelectorName = LIST_CLASSES.get();
			cssType = elementCSSType.CLASS;
			dw.logEvent(UT_FLUID_GRID, UT_FLUID_GRID_ELEMENT_INSERTED_WITH_CLASS);
		}
	}
	
	if(cssSelectorName == '')
	{	
		var msg = dw.loadString("insertbar/div/fgEmptyID");		
		showError(msg);
		return;
	}

	if(!validateString(cssSelectorName))
	{
		return;
	}

	if (cssType == elementCSSType.ID && isIDInUse(cssSelectorName))
	{
		var msg = dw.loadString("insertbar/div/fgDupID");
		showError(msg);
		return;
	}

	var newStyleSheetManager = new CssGrids.StyleSheetManager(dw,
									dw.getActiveWindow(),
									dwscripts,
									DWfile,
									new StyleSheet(dw)
								);

	insertFluidElement(tagName, cssSelectorName, cssType, newStyleSheetManager);

	window.close();
}


if (typeof CssGrids == 'undefined') CssGrids = {}; // Create our namespace

CssGrids.FluidGridLayoutElement = function (elementName, inDw, inDwscripts, inStyleSheetManager) {

	var self = this;

	self.publicFunctions = [
		'insert'
	];

	self.refs = {
		dw: inDw,
		dwscripts: inDwscripts,
		styleSheetManager: inStyleSheetManager
	};

	self.consts = {
		elementName: elementName
	};

	self.insert = function (cssSelector, cssType) {
		if (!self.refs.styleSheetManager.loadGridProps()) {
			// Style Sheet Manager will report error for us.
			return;
		}
		
		var cssChar = '#';
		var cssTypeName = 'id';
		if (cssType == elementCSSType.CLASS)
		{
			cssChar = '.';
			cssTypeName = 'class';
		}
		// Insert html and css.			
		var html = self.getHtmlToInsert(cssSelector, cssTypeName);
		var dom = self.refs.dw.getDocumentDOM();
        if (self.refs.dw.getFocus(false) == 'textView') {
			insertHTMLWithCodeViewInFocus(html);
        }
        else {
			insertHTMLWithDesignViewInFocus(html);
        }
		if( ((elementCSSType.CLASS == cssType) && !LIST_CLASSES.find(cssSelector))
		||	((elementCSSType.ID == cssType) && !LIST_IDS.find(cssSelector))
		)
		{
            self.refs.styleSheetManager.insertRule(cssChar + cssSelector); // insert css after html is inserted
		}
		dom.setInactiveDeviceIconsModified();
	}

	self.getHtmlToInsert = function (cssSelector, cssTypeName) {
		var content = '';
		if (elementName == 'figure') {
			var figureContent = dw.loadString('Objects/layout/figure/defaultFluidContent');
			content = self.refs.dw.loadString('Objects/layout/figcaption/defaultContent');
			content = figureContent + '<figcaption>' + content + '</figcaption>';
		}
		else {
			content = self.refs.dw.loadString('Objects/layout/' + elementName + '/defaultFluidContent');
		}
		content = self.refs.dwscripts.sprintf(content, cssSelector);
		if (cssTypeName == 'class') {
			cssSelector = 'fluid ' + cssSelector;
			return '<' + elementName + ' ' + cssTypeName+ '="' + cssSelector + '">' + content + '</' + elementName + '>';
		}
		else {
			return '<' + elementName + ' ' + cssTypeName+ '="' + cssSelector + '" class="fluid">' + content + '</' + elementName + '>';
		}
	}
}

function insertHTMLWithCodeViewInFocus(html) {
	var domSource =  dw.getDocumentDOM().source;
    var selOffsets = domSource.getSelection();
    domSource.insert(selOffsets[1], html); // insert at the end of the selection in code view
    domSource.setSelection(selOffsets[1], selOffsets[1] + html.length); // Select the inserted code
    domSource.syncCodeToDOM();
}

function insertHTMLWithDesignViewInFocus(html) {
	var dom = dw.getDocumentDOM();
	var gridContainers = dom.getElementsByClassName("gridContainer clearfix");
	var offsets = dom.getSelection();
	var isInsideGridContainer = false;
	if(gridContainers.length > 0)
	{
		var gridContainerToInsertOffsets = dom.nodeToOffsets(gridContainers[gridContainers.length - 1]);
		var NearestGridContainerFound = false;
		for( index in gridContainers)
		{
			var gridContainerOffsets = dom.nodeToOffsets(gridContainers[index]);
			if(offsets[1] < gridContainerOffsets[0] && !NearestGridContainerFound)
			{
				gridContainerToInsertOffsets = gridContainerOffsets;
				NearestGridContainerFound = true;
				break;
			}
			if((offsets[0] > gridContainerOffsets[0]) && (offsets[1] < gridContainerOffsets[1]))
			{
				isInsideGridContainer = true;
				break;
			}
		}
		if(!isInsideGridContainer)
		{
			/* If the selection is out of gridContainer, force the selection inside the last available gridContainer. */
			var endTag = '</div>'; //gridContainer will always be a div.
			if(gridContainerToInsertOffsets)
			{
				var insertOffset = gridContainerToInsertOffsets[1] - endTag.length;
				dom.setSelection(insertOffset, insertOffset);
			}	
		}
	}
	dom.insertHTML(html, false, false); // this will select the newly inserted snippet	
}

function insertFluidElement(elementName, cssSelector, cssType, styleSheetManager) {		
    var newFluidElement = new CssGrids.FluidGridLayoutElement(
															elementName,
															dw,
															dwscripts,
															styleSheetManager
														    );
    newFluidElement.insert(cssSelector, cssType);
}
